<?php
include('../includes/session.php');
include('../includes/config.php');
include('../template/tngweb/header.php');

$appliedby = $udata['phone'];

if ($udata['type'] == 'admin') {
    $res = mysqli_query($tng_conn, "SELECT * FROM recharge_history ORDER BY id DESC");
} else {
    $res = mysqli_query($tng_conn, "SELECT * FROM recharge_history WHERE userid='$appliedby' ORDER BY id DESC");
}
?>

<!--start page wrapper -->
<div class="page-wrapper">
  <div class="page-content">
    <div class="card radius-15 shadow-lg border-0">
      <div class="card-body">
        <!-- Back Button -->
        <div class="d-flex align-items-center justify-content-between mb-3">
          <a href="javascript:void(0);" onclick="window.history.back();" class="btn btn-outline-primary rounded-pill px-4 py-2 fw-semibold">
            <i class="bi bi-arrow-left-circle me-2"></i> Go Back
          </a>
          <h5 class="mb-0 fw-bold text-primary">💰 All Reacharge History</h5>
        </div>
        <hr>

        <div class="table-responsive">
          <table id="walletTable" class="table table-hover table-striped align-middle text-center">
            <thead class="table-dark">
              <tr>
                            <th>#</th>
                            <th>Mobile/ID</th>
                            <th>Operator</th>
                            <th>Amount</th>
                            <th>Status</th>
                            <th>Commission</th>
                            <th>Message</th>
                            <th>Date</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                        $x = 0;
                        while($data = mysqli_fetch_assoc($res)){
                            $x++;
                            $statusBtn = '';

                            if (stripos($data['status'], 'Pending') !== false) {
                                $statusBtn = '<a href="check_status.php?txn_id='.$data['agentid'].'" class="btn btn-sm btn-warning">Check Status</a>';
                            } elseif (stripos($data['status'], 'Success') !== false) {
                                $statusBtn = '<a href="receipt.php?txn_id='.$data['agentid'].'" target="_blank" class="btn btn-sm btn-success">Print Receipt</a>';
                            } elseif (stripos($data['status'], 'Refunded') !== false) {
                                $statusBtn = '<span class="badge bg-info">Refunded</span>';
                            } elseif (stripos($data['status'], 'Failed') !== false) {
                                $statusBtn = '<span class="badge bg-danger">Failed</span>';
                            } else {
                                $statusBtn = '<span class="badge bg-secondary">'.$data['status'].'</span>';
                            }

                            echo "<tr>
                                <td>{$x}</td>
                                <td>{$data['mobile']}</td>
                                <td>{$data['operator']}</td>
                                <td>₹{$data['amount']}</td>
                                <td>{$statusBtn}</td>
                                <td>₹{$data['commission']}</td>
                                <td>{$data['msg']}</td>
                                <td>{$data['date']}</td>
                            </tr>";
                        }
                        ?>
            </tbody>
          </table>
        </div>
      </div>
    </div>
  </div>
</div>
<!--end page wrapper -->

<?php include('../template/tngweb/footer.php'); ?>

<!-- ✅ DataTables CDN & Scripts -->
<script src="../template/tngweb/assets/plugins/simplebar/js/simplebar.min.js"></script>
<script src="../template/tngweb/assets/plugins/metismenu/js/metisMenu.min.js"></script>
<script src="../template/tngweb/assets/plugins/perfect-scrollbar/js/perfect-scrollbar.js"></script>
<script src="../template/tngweb/assets/js/app.js"></script>


<script>
  $(document).ready(function() {
    $('#walletTable').DataTable({
      lengthChange: false,
      pageLength: 10,
      order: [[0, "desc"]],
      buttons: ['copy', 'excel', 'pdf', 'print'],
      dom: '<"d-flex justify-content-between align-items-center mb-3"Bf>rt<"d-flex justify-content-between align-items-center"ip>'
    });
  });
</script>

<style>
  /* 🌟 Stylish Table */
  .table thead th {
    vertical-align: middle;
    font-weight: 600;
    letter-spacing: 0.3px;
  }

  .table tbody tr:hover {
    background: #f5f8ff;
    transition: 0.2s ease;
  }

  .card {
    background: #fff;
    border-radius: 15px;
  }

  .btn-outline-primary {
    border-color: #0055ff;
    color: #0055ff;
  }

  .btn-outline-primary:hover {
    background-color: #0055ff;
    color: #fff;
  }

  .dataTables_wrapper .dataTables_filter input {
    border-radius: 8px;
    padding: 5px 10px;
  }

  .dataTables_wrapper .dataTables_paginate .paginate_button {
    border-radius: 5px;
  }

  .dataTables_wrapper .dt-buttons .btn {
    border-radius: 20px !important;
    font-size: 0.85rem;
    margin-right: 6px;
  }

  .badge {
    font-size: 0.8rem;
    padding: 6px 10px;
  }
</style>
