<?php
include('../includes/session.php');
include('../includes/config.php');
include('../template/tngweb/header.php');

// ✅ Admin Check
if (!isset($udata['id']) || $udata['id'] != 1 || $udata['type'] != 'admin') {
    echo '<script>
    alert("Access Denied! Only Admin can view this page.");
    window.location.href = "../includes/logout.php";
    </script>';
    exit;
}

$site_data = getPopupData($tng_conn);


$alert_msg = '';
$alert_type = '';

if (isset($_POST['popupupdate'])) {
    list($alert_msg, $alert_type) = updatePopupData(
        $tng_conn,
        $_POST['popupalert'] ?? '',
        $_POST['popup_active'] ?? ''
    );
}
?>


<!--start page wrapper -->
<div class="page-wrapper">
  <div class="page-content">
    <div class="card radius-15 shadow-lg border-0">
      <div class="card-body">

      <!-- Alert -->
      <?php if(!empty($alert_msg)): ?>
      <div class="alert alert-<?= $alert_type ?> alert-dismissible fade show" role="alert" style="font-weight:600; font-size:16px;">
        <?= $alert_msg ?>
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
      </div>
      <?php endif; ?>

      <!-- Back Button -->
        <div class="d-flex align-items-center justify-content-between mb-3">
          <a href="javascript:void(0);" onclick="window.history.back();" class="btn btn-outline-primary rounded-pill px-4 py-2 fw-semibold">
            <i class="bi bi-arrow-left-circle me-2"></i> Go Back
          </a>
          <h3 class="mb-4 text-info">⚙️ Manage Popup Alert</h3>
        </div>
       
        
        <form class="row" method="POST" action="">
          <!-- Editor -->
          <div class="col-md-12 mb-3">
            <label class="form-label text-light">Popup Content</label>
            <textarea id="popupalert" name="popupalert" required><?= htmlspecialchars($site_data['popupalert'] ?? '') ?></textarea>
          </div>

          <!-- Status -->
          <div class="col-md-3 mb-3">
            <label class="form-label text-light">Popup Status</label>
            <select name="popup_active" class="form-select" required>
              <option <?= ($site_data['popup_active'] ?? '') === "on" ? 'selected':'' ?> value="on">ON</option>
              <option <?= ($site_data['popup_active'] ?? '') === "off" ? 'selected':'' ?> value="off">OFF</option>
            </select>
          </div>

          <!-- Submit -->
          <div class="col-md-4 mb-3 align-self-end">
            <button type="submit" class="btn btn-gradient w-100" name="popupupdate">💾 Update Popup</button>
          </div>
        </form>
       </div>
      </div>

     </div>
    </div>
   </div>
  </div>
 </div>
</div>


<!-- ✅ Summernote CSS (Bootstrap 4 build for color picker) -->
<link href="https://cdnjs.cloudflare.com/ajax/libs/summernote/0.8.20/summernote-bs4.min.css" rel="stylesheet">

<!-- jQuery + Bootstrap 4 + Summernote -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.bundle.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/summernote/0.8.20/summernote-bs4.min.js"></script>




<script src="../template/tngweb/assets/js/bootstrap.bundle.min.js"></script>
<script src="../template/tngweb/assets/plugins/simplebar/js/simplebar.min.js"></script>
<script src="../template/tngweb/assets/plugins/simplebar/js/simpleba.js"></script>
<script src="../template/tngweb/assets/plugins/metismenu/js/metisMenu.min.js"></script>
<script src="../template/tngweb/assets/plugins/perfect-scrollbar/js/perfect-scrollbar.js"></script>
<script src="../template/tngweb/assets/js/app.js"></script>
</html>

</html>
