<?php
include('../includes/session.php');
include('../includes/config.php');
include('../template/tngweb/header.php');

if (!isset($udata['id']) || $udata['type'] != 'admin') {
    echo '<script>alert("Access Denied!"); window.location.href="../includes/logout.php";</script>';
    exit;
}

$recharge_json = get_recharge_json($tng_conn);

$alert_msg = '';
$alert_type = '';

if(isset($_POST['update_recharge'])){
    $commissions = $_POST['commission'] ?? [];
    $updated = update_recharge_json($tng_conn, $commissions);

    if($updated){
        $alert_msg = "✅ Recharge API Commissions Updated Successfully!";
        $alert_type = "success";
        $recharge_json = $updated;
    } else {
        $alert_msg = "❌ SQL Error: ".mysqli_error($tng_conn);
        $alert_type = "danger";
    }
}

?>
<!--start page wrapper -->
<div class="page-wrapper">
  <div class="page-content">
    <div class="card radius-15 shadow-lg border-0">
      <div class="card-body">
        <!-- Back Button -->
        <div class="d-flex align-items-center justify-content-between mb-3">
          <a href="javascript:void(0);" onclick="window.history.back();" class="btn btn-outline-primary rounded-pill px-4 py-2 fw-semibold">
            <i class="bi bi-arrow-left-circle me-2"></i> Go Back
          </a>
          <h5 class="mb-0 fw-bold text-primary">💰 Manage Recharge API Operators (Only Commission Editable)</h5>
        </div>
        <hr>

        <div class="table-responsive">
          <table id="walletTable" class="table table-hover table-striped align-middle text-center">
            <thead class="table-dark">
              <tr>
                    <th>ID</th>
                    <th>Operator Name</th>
                    <th>Commission (%)</th>
                </tr>
            </thead>
            <tbody>
                <?php
                if(!empty($recharge_json)){
                    foreach($recharge_json as $index => $op){
                        echo '<tr>
                                <td><input type="text" class="form-control" value="'.htmlspecialchars($op['OperatorID']).'" readonly></td>
                                <td><input type="text" class="form-control" value="'.htmlspecialchars($op['OperatorName']).'" readonly></td>
                                <td><input type="text" class="form-control" name="commission[]" value="'.htmlspecialchars($op['Commission']).'"></td>
                              </tr>';
                    }
                }
                ?>
            </tbody>
        </table>
        <button type="submit" class="btn btn-primary" name="update_recharge">💾 Update Commissions</button>
    </form>
</div>

<?php if(!empty($alert_msg)): ?>
<script>
Swal.fire({
    html: `<?= $alert_msg ?>`,
    icon: '<?= $alert_type ?>',
    showConfirmButton: false,
    showCloseButton: true
});
</script>
<?php endif; ?>

          
<!--end page wrapper -->

<?php include('../template/tngweb/footer.php'); ?>

<!-- ✅ DataTables CDN & Scripts -->
<script src="../template/tngweb/assets/plugins/simplebar/js/simplebar.min.js"></script>
<script src="../template/tngweb/assets/plugins/metismenu/js/metisMenu.min.js"></script>
<script src="../template/tngweb/assets/plugins/perfect-scrollbar/js/perfect-scrollbar.js"></script>
<script src="../template/tngweb/assets/js/app.js"></script>


<script>
  $(document).ready(function() {
    $('#walletTable').DataTable({
      lengthChange: false,
      pageLength: 10,
      order: [[0, "desc"]],
      buttons: ['copy', 'excel', 'pdf', 'print'],
      dom: '<"d-flex justify-content-between align-items-center mb-3"Bf>rt<"d-flex justify-content-between align-items-center"ip>'
    });
  });
</script>

<style>
  /* 🌟 Stylish Table */
  .table thead th {
    vertical-align: middle;
    font-weight: 600;
    letter-spacing: 0.3px;
  }

  .table tbody tr:hover {
    background: #f5f8ff;
    transition: 0.2s ease;
  }

  .card {
    background: #fff;
    border-radius: 15px;
  }

  .btn-outline-primary {
    border-color: #0055ff;
    color: #0055ff;
  }

  .btn-outline-primary:hover {
    background-color: #0055ff;
    color: #fff;
  }

  .dataTables_wrapper .dataTables_filter input {
    border-radius: 8px;
    padding: 5px 10px;
  }

  .dataTables_wrapper .dataTables_paginate .paginate_button {
    border-radius: 5px;
  }

  .dataTables_wrapper .dt-buttons .btn {
    border-radius: 20px !important;
    font-size: 0.85rem;
    margin-right: 6px;
  }

  .badge {
    font-size: 0.8rem;
    padding: 6px 10px;
  }
</style>