<?php
include('../includes/session.php');
include('../includes/config.php');
include('../template/tngweb/header.php');

$fee = $udata['dl_to_mobile_fee'] ?? 20;
checkServiceStatus($udata, 'dl_to_mobile_fee_status');

if ($_POST['dl_number']) {
    $dl_number = $_POST['dl_number'];
    $appliedby = $udata['phone'];
    $debit_fee = $udata['balance'] - $fee;

    if ($udata['balance'] >= $fee) {
        $request = [
            'dl_number' => $dl_number,
        ];

        $result = dl_to_mobile_find_verification_api_run($request);

        
        $resdata = json_decode(json_encode($result), true);
        $sampleCode = $resdata['sampleCode'] ?? '';
        $errore = $resdata['error'] ?? '';
        $parentPhone = $udata['parent'] ?? null;

        if ($errore) {
            echo "<script>$(function(){ Swal.fire('$errore', 'Something went wrong.', 'error') }); setTimeout(() => { window.location=''; }, 4000);</script>";
        } elseif ($sampleCode === "200") {
            $debit = mysqli_query($tng_conn, "UPDATE users SET balance=balance-$fee WHERE phone='$appliedby'");
            addCommission($tng_conn, $appliedby, $fee, $parentPhone, 'Driving Licence To Mobile Finder');
            $updatehistory = mysqli_query($tng_conn, "INSERT INTO wallethistory(userid, amount, balance, purpose, status, type) VALUES ('$appliedby','$fee','$debit_fee','Driving Licence To Mobile Finder','1','Debit')");
        }
    } else {
        echo "<script>$(function(){ Swal.fire('Wallet Balance is Low!', 'Please Recharge Now!', 'error') }); setTimeout(() => { window.location='wallet.php'; }, 1200);</script>";
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Driving Licence To Mobile Finder</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <script src="https://cdn.jsdelivr.net/npm/html2canvas@1.4.1/dist/html2canvas.min.js"></script>
<link rel="stylesheet" href="../template/tngweb/assets/plugins/metismenu/css/dl_to_mobile.css">
</head>
<body>
<div class="page-wrapper">
    <div class="container">
        <div class="text-center mb-5">
            <h1 class="fw-bold text-primary mb-2">Driving Licence To Mobile Finder</h1>
            <p class="text-muted fs-5">Find Mobile Number easily with Driving Licence number (All States)</p>
        </div>

        <div class="row justify-content-center">
            <div class="col-lg-5 col-md-6 mb-4">
                <div class="card rounded-4">
                    <div class="card-header py-3 text-center">
                        <h4 class="mb-0"><i class="fas fa-id-card me-2"></i> DRIVING LICENCE TO MOBILE FINDER</h4>
                    </div>
                    <div class="card-body p-4">
                        <form action="" method="POST" class="needs-validation" novalidate>
                            <div class="mb-4">
                                <label for="dl_number" class="form-label fw-semibold">Enter Driving Licence Number</label>
                                <input name="dl_number" type="text" id="dl_number" placeholder="Enter Driving Licence Number" class="form-control form-control-lg" required>
                                <div class="form-text">Enter your complete driving licence number as per your licence</div>
                            </div>

                            <div class="d-flex justify-content-between align-items-center mt-4 pt-3 border-top">
                                <div class="fee-badge">
                                    <i class="fas fa-rupee-sign me-1"></i> Fee: ₹ <?php echo $fee; ?>
                                </div>
                                <button type="submit" class="btn btn-primary btn-lg px-4">
                                    <i class="fas fa-search me-2"></i> Find Details
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
                
                
                <div class="card mt-4 rounded-4">
                    <div class="card-body">
                        <h5 class="card-title text-primary"><i class="fas fa-info-circle me-2"></i> Important Information</h5>
                        <ul class="list-group list-group-flush">
                            <li class="list-group-item d-flex">
                                <i class="fas fa-check-circle text-success me-2 mt-1"></i>
                                <span>Service available for all states in India</span>
                            </li>
                            <li class="list-group-item d-flex">
                                <i class="fas fa-check-circle text-success me-2 mt-1"></i>
                                <span>Instant results with accurate information</span>
                            </li>
                            <li class="list-group-item d-flex">
                                <i class="fas fa-check-circle text-success me-2 mt-1"></i>
                                <span>Secure and confidential process</span>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>

           
            <?php if (!empty($sampleCode) && $sampleCode === "200") { ?>
            <div class="col-lg-7 col-md-6">
                <div class="card result-card rounded-4">
                    <div class="card-body p-4">
                        <div class="d-flex justify-content-between align-items-center mb-4">
                            <h3 class="section-title mb-0">Applicant Details</h3>
                            <button id="downloadBtn" class="btn btn-download">
                                <i class="fas fa-download me-2"></i> Download Result
                            </button>
                        </div>
                        
                        <div class="row" id="resultContent">
                            <!-- Status Badge -->
                            <div class="col-12 mb-4">
                                <div class="status-badge success-badge d-inline-flex align-items-center">
                                    <i class="fas fa-check-circle me-2"></i>
                                    <span>Data Found Successfully</span>
                                </div>
                            </div>
                            
                            <!-- Personal Details -->
                            <div class="col-md-6 mb-3">
                                <div class="info-box">
                                    <div class="info-label">Driving Licence Number</div>
                                    <div class="info-value fs-5 fw-bold text-primary"><?php echo htmlspecialchars($resdata['dl_number'] ?? $dl_number); ?></div>
                                </div>
                            </div>
                            
                            <div class="col-md-6 mb-3">
                                <div class="info-box">
                                    <div class="info-label">Full Name</div>
                                    <div class="info-value fs-5"><?php echo htmlspecialchars($resdata['fullname'] ?? ''); ?></div>
                                </div>
                            </div>
                            
                            <div class="col-md-6 mb-3">
                                <div class="info-box">
                                    <div class="info-label">Father's Name</div>
                                    <div class="info-value"><?php echo htmlspecialchars($resdata['fathername'] ?? ''); ?></div>
                                </div>
                            </div>
                            
                            <div class="col-md-6 mb-3">
                                <div class="info-box">
                                    <div class="info-label">Date of Birth</div>
                                    <div class="info-value"><?php echo htmlspecialchars($resdata['dob'] ?? ''); ?></div>
                                </div>
                            </div>
                            
                            <div class="col-md-6 mb-3">
                                <div class="info-box">
                                    <div class="info-label">Gender</div>
                                    <div class="info-value"><?php echo htmlspecialchars($resdata['gender'] ?? ''); ?></div>
                                </div>
                            </div>
                            
                            <div class="col-md-6 mb-3">
                                <div class="info-box">
                                    <div class="info-label">Mobile Number</div>
                                    <div class="info-value fs-5 fw-bold text-success"><?php echo htmlspecialchars($resdata['mobileNumber'] ?? ''); ?></div>
                                </div>
                            </div>
                            
                            <!-- Address Details -->
                            <div class="col-12 mt-3">
                                <h5 class="section-title">Address & RTO Details</h5>
                            </div>
                            
                            <div class="col-md-6 mb-3">
                                <div class="info-box">
                                    <div class="info-label">State</div>
                                    <div class="info-value"><?php echo htmlspecialchars($resdata['state'] ?? ''); ?></div>
                                </div>
                            </div>
                            
                            <div class="col-md-6 mb-3">
                                <div class="info-box">
                                    <div class="info-label">RTO Office</div>
                                    <div class="info-value"><?php echo htmlspecialchars($resdata['rto'] ?? ''); ?></div>
                                </div>
                            </div>
                            
                            <!-- Application Details -->
                            <div class="col-12 mt-3">
                                <h5 class="section-title">Application Details</h5>
                            </div>
                            
                            <div class="col-12 mb-3">
                                <div class="info-box">
                                    <div class="info-label">Application Number</div>
                                    <div class="info-value"><?php echo htmlspecialchars($resdata['application_no'] ?? ''); ?></div>
                                </div>
                            </div>
                            
                            <!-- Message -->
                            <div class="col-12 mt-4">
                                <div class="alert alert-info">
                                    <i class="fas fa-info-circle me-2"></i>
                                    <strong>Note:</strong> This information is retrieved from official records. Please verify the details with the original documents.
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php } ?>
        </div>
    </div>
</div>


<?php include('../template/tngweb/footer.php'); ?>

<!-- Populate States -->


<!-- Bootstrap & JS -->

<script src="../template/tngweb/assets/plugins/metismenu/js/metisMenu.min.js"></script>
<script src="../template/tngweb/assets/plugins/metismenu/js/dl_to_mobile.js"></script>
<script src="../template/tngweb/assets/plugins/perfect-scrollbar/js/perfect-scrollbar.js"></script>
<script src="../template/tngweb/assets/js/app.js"></script>
  
</body>
</html>